/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.gen.feature.DecoratedHugeFungusConfiguration;
import cy.jdkdigital.productivebees.gen.feature.NetherBeehiveDecorator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;
import net.minecraft.world.level.material.Material;

public class DecoratedHugeFungusFeature
extends Feature<DecoratedHugeFungusConfiguration> {
    public DecoratedHugeFungusFeature(Codec<DecoratedHugeFungusConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<DecoratedHugeFungusConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        Random random = pContext.m_159776_();
        ChunkGenerator chunkgenerator = pContext.m_159775_();
        DecoratedHugeFungusConfiguration configuration = (DecoratedHugeFungusConfiguration)pContext.m_159778_();
        Block block = configuration.f_65897_.m_60734_();
        BlockState blockstate = worldgenlevel.m_8055_(blockpos.m_7495_());
        if (blockstate.m_60713_(block)) {
            int i = Mth.m_14072_((Random)random, (int)4, (int)13);
            if (random.nextInt(12) == 0) {
                i *= 2;
            }
            if (!configuration.f_65901_) {
                int j = chunkgenerator.m_6331_();
                if (blockpos.m_123342_() + i + 1 >= j) {
                    return false;
                }
            }
            boolean flag = !configuration.f_65901_ && random.nextFloat() < 0.06f;
            worldgenlevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 4);
            ArrayList<BlockPos> pLogPositions = new ArrayList<BlockPos>();
            ArrayList<BlockPos> pLeafPositions = new ArrayList<BlockPos>();
            this.placeStem((LevelAccessor)worldgenlevel, random, configuration, blockpos, i, flag, pLogPositions);
            this.placeHat((LevelAccessor)worldgenlevel, random, configuration, blockpos, i, flag, pLeafPositions);
            if (!configuration.decorators.isEmpty()) {
                BiConsumer<BlockPos, BlockState> biconsumer = (pos, state) -> worldgenlevel.m_7731_(pos, state, 19);
                pLogPositions.sort(Comparator.comparingInt(Vec3i::m_123342_));
                pLeafPositions.sort(Comparator.comparingInt(Vec3i::m_123342_));
                configuration.decorators.forEach(decorator -> {
                    if (decorator instanceof NetherBeehiveDecorator) {
                        ((NetherBeehiveDecorator)((Object)decorator)).setNest(configuration.nestState);
                    }
                    decorator.m_142741_((LevelSimulatedReader)worldgenlevel, biconsumer, random, pLogPositions, pLeafPositions);
                });
            }
            return true;
        }
        return false;
    }

    private static boolean isReplaceable(LevelAccessor pLevel, BlockPos pPos, boolean pReplacePlants) {
        return pLevel.m_7433_(pPos, state -> state.m_60767_().m_76336_() || pReplacePlants && state.m_60767_() == Material.f_76300_);
    }

    private void placeStem(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos pPos, int pHeight, boolean pDoubleWide, List<BlockPos> positions) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockState blockstate = pConfig.f_65898_;
        int i = pDoubleWide ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean flag = pDoubleWide && Mth.m_14040_((int)j) == i && Mth.m_14040_((int)k) == i;
                for (int l = 0; l < pHeight; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)pPos, j, l, k);
                    if (!DecoratedHugeFungusFeature.isReplaceable(pLevel, (BlockPos)blockpos$mutableblockpos, true)) continue;
                    positions.add(blockpos$mutableblockpos.m_7949_());
                    if (pConfig.f_65901_) {
                        if (!pLevel.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60795_()) {
                            pLevel.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                        }
                        pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 3);
                        continue;
                    }
                    if (flag) {
                        if (!(pRandom.nextFloat() < 0.1f)) continue;
                        this.m_5974_((LevelWriter)pLevel, (BlockPos)blockpos$mutableblockpos, blockstate);
                        continue;
                    }
                    this.m_5974_((LevelWriter)pLevel, (BlockPos)blockpos$mutableblockpos, blockstate);
                }
            }
        }
    }

    private void placeHat(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos pPos, int pHeight, boolean pDoubleWide, List<BlockPos> positions) {
        int j;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean flag = pConfig.f_65899_.m_60713_(Blocks.f_50451_);
        int i = Math.min(pRandom.nextInt(1 + pHeight / 3) + 5, pHeight);
        for (int k = j = pHeight - i; k <= pHeight; ++k) {
            int l;
            int n = l = k < pHeight - pRandom.nextInt(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (pDoubleWide) {
                ++l;
            }
            for (int i1 = -l; i1 <= l; ++i1) {
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1 = i1 == -l || i1 == l;
                    boolean flag2 = j1 == -l || j1 == l;
                    boolean flag3 = !flag1 && !flag2 && k != pHeight;
                    boolean flag4 = flag1 && flag2;
                    boolean flag5 = k < j + 3;
                    blockpos$mutableblockpos.m_122154_((Vec3i)pPos, i1, k, j1);
                    if (!DecoratedHugeFungusFeature.isReplaceable(pLevel, (BlockPos)blockpos$mutableblockpos, false)) continue;
                    positions.add(blockpos$mutableblockpos.m_7949_());
                    if (pConfig.f_65901_ && !pLevel.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60795_()) {
                        pLevel.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                    }
                    if (flag5) {
                        if (flag3) continue;
                        this.placeHatDropBlock(pLevel, pRandom, (BlockPos)blockpos$mutableblockpos, pConfig.f_65899_, flag);
                        continue;
                    }
                    if (flag3) {
                        this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 0.1f, 0.2f, flag ? 0.1f : 0.0f);
                        continue;
                    }
                    if (flag4) {
                        this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 0.01f, 0.7f, flag ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock(pLevel, pRandom, pConfig, blockpos$mutableblockpos, 5.0E-4f, 0.98f, flag ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(LevelAccessor pLevel, Random pRandom, HugeFungusConfiguration pConfig, BlockPos.MutableBlockPos pPos, float pDecorationChance, float pHatChance, float pWeepingVineChance) {
        if (pRandom.nextFloat() < pDecorationChance) {
            this.m_5974_((LevelWriter)pLevel, (BlockPos)pPos, pConfig.f_65900_);
        } else if (pRandom.nextFloat() < pHatChance) {
            this.m_5974_((LevelWriter)pLevel, (BlockPos)pPos, pConfig.f_65899_);
            if (pRandom.nextFloat() < pWeepingVineChance) {
                DecoratedHugeFungusFeature.tryPlaceWeepingVines((BlockPos)pPos, pLevel, pRandom);
            }
        }
    }

    private void placeHatDropBlock(LevelAccessor pLevel, Random pRandom, BlockPos pPos, BlockState pState, boolean pWeepingVines) {
        if (pLevel.m_8055_(pPos.m_7495_()).m_60713_(pState.m_60734_())) {
            this.m_5974_((LevelWriter)pLevel, pPos, pState);
        } else if ((double)pRandom.nextFloat() < 0.15) {
            this.m_5974_((LevelWriter)pLevel, pPos, pState);
            if (pWeepingVines && pRandom.nextInt(11) == 0) {
                DecoratedHugeFungusFeature.tryPlaceWeepingVines(pPos, pLevel, pRandom);
            }
        }
    }

    private static void tryPlaceWeepingVines(BlockPos pPos, LevelAccessor pLevel, Random pRandom) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_().m_122173_(Direction.DOWN);
        if (pLevel.m_46859_((BlockPos)blockpos$mutableblockpos)) {
            int i = Mth.m_14072_((Random)pRandom, (int)1, (int)5);
            if (pRandom.nextInt(7) == 0) {
                i *= 2;
            }
            int j = 23;
            int k = 25;
            WeepingVinesFeature.m_67376_((LevelAccessor)pLevel, (Random)pRandom, (BlockPos.MutableBlockPos)blockpos$mutableblockpos, (int)i, (int)23, (int)25);
        }
    }
}

